<?php
// Cấu hình kết nối cơ sở dữ liệu
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Xử lý OPTIONS request cho CORS
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Cấu hình cơ sở dữ liệu - Auto detect environment
$isLocal = (strpos($_SERVER['HTTP_HOST'] ?? '', 'localhost') !== false || 
           strpos($_SERVER['HTTP_HOST'] ?? '', '127.0.0.1') !== false);

if ($isLocal) {
    // Local development
    define('DB_HOST', 'localhost');
    define('DB_NAME', 'apixtea1_24hpk');
    define('DB_USER', 'root');
    define('DB_PASS', '');
} else {
    // Production hosting
    define('DB_HOST', 'localhost');
    define('DB_NAME', 'apixtea1_24hpk');
    define('DB_USER', 'apixtea1_24hpk');
    define('DB_PASS', 'minhchanh9x@!');
}
define('DB_CHARSET', 'utf8mb4');

// Tạo kết nối PDO với cấu hình UTF-8
try {
    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
    ]);
    
    // Đảm bảo charset UTF-8
    $pdo->exec("SET CHARACTER SET utf8mb4");
    $pdo->exec("SET NAMES utf8mb4");
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Lỗi kết nối cơ sở dữ liệu',
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

// Hàm trả về JSON với encoding UTF-8
function returnJson($data, $status = 200) {
    http_response_code($status);
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit();
}

?>